/*
  I2C Master ESP8266
  Demo van communicatie mbv de I2C bus
  Master stuurt een teken, de slave antwoord hierop
  Gebruikt: ESP8266  NodeMcu V3 Lua Wireless
*/

// Include Arduino Wire library for I2C
#include <Wire.h>

// Define Slave I2C Address
#define SLAVE_ADDR_1 9
#define SLAVE_ADDR_2 10
#define SLAVE_ADDR_3 11
#define SLAVE_ADDR_4 12

// Define Slave answer size
#define ANSWERSIZE 23

void setup() {

  // Initialize I2C communications as Master
  Wire.begin(4, 0); // pin D2, D3

  // Setup serial monitor
  Serial.begin(9600);
  Serial.println("I2C Master Demo");
}

void loop() {
  communicate(SLAVE_ADDR_1);
  communicate(SLAVE_ADDR_2);
  communicate(SLAVE_ADDR_3);
  communicate(SLAVE_ADDR_4);

  Serial.println("------------------------");

  delay(3000);
}

void communicate(int adress) {

  delay(50);

  String answer = "Hallo NANO HEX $0";
  String adressHex = String(adress, HEX);
  adressHex.toUpperCase();
  answer += adressHex + "  :) ";

  Serial.print("Verstuur data naar NANO slave: ");
  Serial.print(answer);
  Serial.print("    |    ");

  // Write characters to the Slave

  byte responseMaster[ANSWERSIZE];
  for (byte i = 0; i < ANSWERSIZE; i++) {
    responseMaster[i] = (byte)answer.charAt(i);
  }
  Wire.beginTransmission(adress);
  Wire.write(responseMaster, sizeof(responseMaster));
  Wire.endTransmission();

  Serial.print("Antwoord NANO :");

  // Read response from Slave
  // Read back 'ANSWERSIZE' characters
  Wire.requestFrom(adress, ANSWERSIZE);

  // Add characters to string
  String response = "";
  while (Wire.available()) {
    char b = Wire.read();
    response += b;
  }

  // Print to Serial Monitor
  Serial.println(response);
}
